package ru.yandex.travel.api.services.orders.happy_page.model;

import java.time.LocalDateTime;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.javamoney.moneta.Money;

import ru.yandex.travel.api.models.Linguistics;
import ru.yandex.travel.api.services.orders.happy_page.afisha.model.AfishaCityCoordinates;

@Data
@EqualsAndHashCode(callSuper = true)
public class AfishaCrossSalePayload extends CrossSaleBlockUiPayload {
    private Linguistics regionLinguistics;
    private String regionUrl;
    private List<EventInfo> events;
    private AfishaCityCoordinates coordinates;

    @Data
    public static class EventInfo {
        private String name;
        private Money minPrice;
        private String type;
        private LocalDateTime dateTime;
        private String dateText;
        private String imageUrl;
        private List<String> tags;
        private String eventUrl;
    }
}
