package ru.yandex.travel.api.services.orders.happy_page.model;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Singular;
import lombok.Value;

import ru.yandex.avia.booking.service.commons.OrderError;
import ru.yandex.avia.booking.service.commons.OrderState;
import ru.yandex.avia.booking.service.dto.AirReservationDTO;
import ru.yandex.avia.booking.service.dto.TravellerInfoDTO;
import ru.yandex.avia.booking.service.dto.promo.AviaPromoCampaignsDTO;
import ru.yandex.avia.booking.service.dto.reference.ReferenceDTO;
import ru.yandex.travel.api.models.hotels.Price;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;

@EqualsAndHashCode(callSuper = true)
@Value
@Builder
public class AviaHappyPageOrder extends HappyPageOrder {
    UUID id;
    String prettyId;
    String partner;
    String variantId;
    String email;
    String phone;
    AirReservationDTO airReservation;
    @Singular
    List<TravellerInfoDTO> travellers;
    Price preliminaryPrice;
    Price price;
    OrderState state;
    LocalDateTime timeLimitAt;
    OrderError errorCode;
    ReferenceDTO reference;
    EDisplayOrderState eDisplayOrderState;
    LocalDateTime servicedAt;
    AviaPromoCampaignsDTO promoCampaigns;
}
