package ru.yandex.travel.api.services.orders.happy_page.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum AviaOrderState {
    NEW("new"),
    BOOKING("booking"),
    BOOKED("booked"),
    PROCESSING_ERROR("processing_error"),
    TICKETED("ticketed"),
    UNRECOGNIZED("unrecognized");

    private final String value;

    private static AviaOrderState fromValue(String value) {
        for (AviaOrderState state : AviaOrderState.values()) {
            if (state.value.equals(value)) {
                return state;
            }
        }
        throw new RuntimeException(String.format("Cannot map %s to AviaOrderState value", value));
    }
}
