package ru.yandex.travel.api.services.orders.happy_page.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
@RequiredArgsConstructor
public enum AviaOrderTravellerDocumentType {
    PASSPORT("passport"),
    INTERNATIONAL_PASSPORT_RU("internation_passport_ru"),
    BIRTH_CERTIFICATE("birth_certificate"),
    NATIONAL_PASSPORT("national_passport");

    private final String value;

    public static AviaOrderTravellerDocumentType fromValue(String value) {
        for (AviaOrderTravellerDocumentType candidate: AviaOrderTravellerDocumentType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new RuntimeException(String.format("Cannot map %s to AviaOrderTravellerDocumentType value", value));
    }
}
