package ru.yandex.travel.api.services.orders.happy_page.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
@RequiredArgsConstructor
public enum AviaOrderTravellerPassengerCategory {
    ADULT("adult"),
    CHILD("child"),
    INFANT("infant");

    private final String value;

    public static AviaOrderTravellerPassengerCategory fromValue(String value) {
        for (AviaOrderTravellerPassengerCategory candidate: AviaOrderTravellerPassengerCategory.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new RuntimeException(String.format("Cannot map %s to AviaOrderTravellerPassengerCategory value", value));
    }
}
