package ru.yandex.travel.api.services.orders.happy_page.model;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Value;

import ru.yandex.travel.api.endpoints.booking_flow.model.OrderPriceInfo;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.CancellationReason;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.ContactInfoDTO;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.GenericOrderState;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.ServiceDTO;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.refund.RefundPartInfo;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;

@EqualsAndHashCode(callSuper = true)
@Value
@Builder(toBuilder = true)
public class BusHappyPageOrder extends HappyPageOrder {
    UUID id;
    String prettyId;
    GenericOrderState state;
    CancellationReason cancellationReason;
    EDisplayOrderState displayState;
    Instant expiresAt;
    Instant servicedAt;
    List<ServiceDTO> services;
    OrderPriceInfo orderPriceInfo;
    BusHappyPagePaymentInfo payment;
    ContactInfoDTO contactInfo;
    RefundPartInfo refundPartInfo;
    UUID tripId = null;
}
