package ru.yandex.travel.api.services.orders.happy_page.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@Getter
@RequiredArgsConstructor
public enum CrossSaleBlockType implements ValueBasedEnum<String> {
    PROMO("promo"),
    HOTEL_CROSS_SALE("hotel_cross_sale"),
    AVIA_CROSS_SALE("avia_cross_sale"),
    TRAIN_CROSS_SALE("train_cross_sale"),
    TRANSPORT_CROSS_SALE("transport_cross_sale"),
    COMMON_PROMO_CODE("common_promo_code"),
    AFISHA_CROSS_SALE("afisha_cross_sale"),
    IZI_TRAVEL_CROSS_SALE("izi_travel_cross_sale"),
    YANDEX_MARKET("yandex_market");

    private final String value;

    public static CrossSaleBlockType fromValue(String value) {
        return EnumIndex.create(CrossSaleBlockType.class).getByValue(value);
    }

    public String toString() {
        return this.value;
    }
}
