package ru.yandex.travel.api.services.orders.happy_page.model;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

import ru.yandex.travel.api.endpoints.travel_orders.req_rsp.OrderHappyPageRspV1;

@Data
public class HappyPageLogRecord {
    private String logId;
    private long timestamp;
    private Long responseTime;
    private OrderHappyPageRspV1 responseBody;
    private String errorInfo;
    private String orderId;
    private String orderPrettyId;
    private String orderType;
    private List<String> serviceType;
    private List<BlockInfo> block;

    public void addServiceType(String serviceType) {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<>();
        }
        this.serviceType.add(serviceType);
    }

    public void addBlock(BlockInfo blockInfo) {
        if (this.block == null) {
            this.block = new ArrayList<>();
        }
        this.block.add(blockInfo);
    }

    @Data
    public static class BlockInfo {
        private String type;
        private long responseTime;
        private boolean shown;
        private String errorInfo;
    }
}
