package ru.yandex.travel.api.services.orders.happy_page.model;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Value;

import ru.yandex.travel.api.endpoints.booking_flow.model.ConfirmationInfo;
import ru.yandex.travel.api.endpoints.booking_flow.model.OrderGuestInfo;
import ru.yandex.travel.api.endpoints.booking_flow.model.OrderPriceInfo;
import ru.yandex.travel.api.endpoints.booking_flow.model.OrderStatus;
import ru.yandex.travel.api.endpoints.booking_flow.model.promo.AppliedPromoCampaignsDto;
import ru.yandex.travel.hotels.common.orders.CancellationDetails;
import ru.yandex.travel.hotels.common.orders.RefundInfo;

@EqualsAndHashCode(callSuper = true)
@Value
@Builder
public class HotelHappyPageOrder extends HappyPageOrder {
    UUID id;
    String yandexOrderId;
    HotelOrderInfo orderInfo;
    OrderGuestInfo guestInfo;
    OrderStatus status;
    CancellationDetails orderCancellationDetails;
    OrderPaymentInfo payment;
    ConfirmationInfo confirmationInfo;
    RefundInfo refundInfo;
    OrderPriceInfo orderPriceInfo;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    AppliedPromoCampaignsDto appliedPromoCampaigns;
}
