package ru.yandex.travel.api.services.orders.happy_page.model;

import java.time.LocalDate;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.travel.api.models.Linguistics;
import ru.yandex.travel.api.models.hotels.Badge;
import ru.yandex.travel.api.models.hotels.Hotel;
import ru.yandex.travel.api.models.hotels.Price;

// Used in pretrip:
// https://a.yandex-team.ru/arc_vcs/travel/notifier/internal/structs/hotels.go
@Data
@EqualsAndHashCode(callSuper = true)
public class HotelPayload extends CrossSaleBlockUiPayload {
    String targetCity;
    int regionGeoId;
    Linguistics regionLinguistics;
    PromoPayload promoBanner;
    List<HotelWithMinPriceBlockInfo> hotelsList;
    String searchUrl;
    RequestParams requestParams;

    @Data
    public static class HotelWithMinPriceBlockInfo {
        Hotel hotel;
        Price minPrice;
        Integer nights;
        List<Badge> badges;
        String landingUrl;
    }

    @Data
    public static class RequestParams {
        LocalDate checkinDate;
        LocalDate checkoutDate;
        int nights;
        int adults;
        List<Integer> childrenAges;
    }
}

