package ru.yandex.travel.api.services.orders.happy_page.model;

import java.util.Map;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.proto.EFiscalReceiptType;

@Getter
@RequiredArgsConstructor
public enum ReceiptItemType {
    ACQUIRE, CLEAR, REFUND;

    private final static Map<EFiscalReceiptType, ReceiptItemType> PROTO_TO_ENUM_MAP = Map.of(
            EFiscalReceiptType.FRT_ACQUIRE, ReceiptItemType.ACQUIRE,
            EFiscalReceiptType.FRT_CLEAR, ReceiptItemType.CLEAR,
            EFiscalReceiptType.FRT_REFUND, ReceiptItemType.REFUND
    );

    public static ReceiptItemType fromProto(EFiscalReceiptType protoType) {
        var receiptType = PROTO_TO_ENUM_MAP.get(protoType);
        if (receiptType == null) {
            throw new RuntimeException(String.format("Cannot map %s to ReceiptItemType value. Unknown proto value",
                    protoType.toString()));
        }
        return receiptType;
    }
}
