package ru.yandex.travel.api.services.orders.happy_page.model;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Singular;
import lombok.Value;

import ru.yandex.travel.api.endpoints.booking_flow.model.PaymentErrorCode;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.ServiceDTO;
import ru.yandex.travel.api.models.train.InsuranceStatus;
import ru.yandex.travel.api.models.train.Passenger;
import ru.yandex.travel.api.models.train.SegmentInfo;
import ru.yandex.travel.api.models.train.Station;
import ru.yandex.travel.api.models.train.TrainInfo;
import ru.yandex.travel.api.models.train.TrainOrderStatus;
import ru.yandex.travel.api.models.train.WarningInfo;

@EqualsAndHashCode(callSuper = true)
@Value
@Builder(toBuilder = true)
public class TrainHappyPageOrder extends HappyPageOrder {
    UUID id;
    String prettyId;
    TrainOrderStatus status;
    TrainOrderError error;
    Instant reservedTo;
    Instant maxPendingTill;
    PaymentErrorCode paymentError;
    String paymentUrl;
    // todo(tlg-13,ganintsev): TRAVELBACK-1828: lots of legacy segment fields here, should be removed during the cleanup
    InsuranceStatus insuranceStatus;
    Integer partnerOrderId;
    Station stationFrom;
    Station stationTo;
    TrainInfo trainInfo;
    String carType;
    String compartmentGender;
    Instant arrival;
    Instant departure;
    String partner;
    String carNumber;
    String specialNotice;
    @Singular
    List<WarningInfo> warnings;
    Boolean twoStorey;
    String coachOwner;
    String companyTitle;
    Instant canChangeElectronicRegistrationTill;
    @Singular
    List<Passenger> passengers;
    Boolean onlyFullReturnPossible;
    String paymentReceiptUrl;
    String customerEmail;
    String customerPhone;
    Boolean rebookingAvailable;
    Boolean reservationProlonged;
    // todo(tlg-13): we're going to replace this field with our standard generic services
    List<SegmentInfo> segments;
    List<ServiceDTO> services;
}
