package ru.yandex.travel.api.services.orders.happy_page.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.api.models.Linguistics;
import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@Data
@EqualsAndHashCode(callSuper = true)
public class TransportPayload extends CrossSaleBlockUiPayload {
    private Linguistics regionFromLinguistics;
    private Linguistics regionToLinguistics;
    private List<TransportBlockInfo> transportBlocks;

    @Data
    public static class TransportBlockInfo {
        private TransportBlockType type;
        private String from;
        private String to;
        private LocalDate departureAt;
        private Integer adults;
        private List<Integer> childrenAges;

        public static TransportBlockInfo emptyBlock(TransportBlockType type) {
            var result = new TransportBlockInfo();
            result.setType(type);
            return result;
        }

        public static TransportBlockInfo copyOf(TransportBlockInfo other) {
            var result = new TransportBlockInfo();
            result.setType(other.getType());
            result.setFrom(other.getFrom());
            result.setTo(other.getTo());
            result.setDepartureAt(other.getDepartureAt());
            result.setAdults(other.getAdults());
            if (other.getChildrenAges() != null) {
                result.setChildrenAges(new ArrayList<>(other.getChildrenAges()));
            }
            return result;
        }
    }

    @RequiredArgsConstructor
    @Getter
    public enum TransportBlockType implements ValueBasedEnum<String> {
        AVIA("avia"),
        TRAIN("trains"),
        BUS("buses");

        private final String value;

        private static final EnumIndex<String, TransportBlockType> INDEX = EnumIndex.create(TransportBlockType.class);

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TransportBlockType fromValue(String value) {
            return INDEX.getByValue(value);
        }
    }
}
