package ru.yandex.travel.api.services.orders.model;


import java.time.Instant;
import java.util.List;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;
import org.javamoney.moneta.Money;

import ru.yandex.travel.api.models.train.Station;
import ru.yandex.travel.train.model.CarType;

import static ru.yandex.travel.api.models.train.TrainOrderMaps.CAR_TYPE_TO_STR;

@Data
public class TrainOrderListInfo {
    // todo(tlg-13,ganintsev): single segment train order legacy fields should be remove in TRAVELBACK-1828
    // legacy fields start
    private Instant reservedTo;
    private Instant maxPendingTill;
    private String reservationNumber;
    private Integer partnerOrderId;
    private Instant arrival;
    private Instant departure;
    private String customerEmail;
    private String customerPhone;
    private Station stationFrom;
    private Station stationTo;
    private TrainOrderListTrainInfo trainInfo;
    @Setter(AccessLevel.NONE)
    private String carType;
    private String carNumber;

    private Instant canChangeElectronicRegistrationTill;
    // legacy fields end
    private List<TrainOrderListSegmentInfo> segments;

    private Money totalAmount;
    private Money refundAmount;
    private Integer refundedTicketsCount;

    // todo(tlg-13,ganintsev): legacy single segment train order fields should be remove in TRAVELBACK-1828
    private List<TrainOrderListInfoPassenger> passengers;

    public void setCarType(CarType value) {
        carType = CAR_TYPE_TO_STR.get(value);
    }
}
