package ru.yandex.travel.api.services.orders.notifier.model;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode
public class OrderInfoPayload {
    private UUID orderId;
    private String prettyId;

    private List<HotelOrderInfo> hotelOrderInfos;
    private List<TrainOrderInfo> trainOrderInfos;

    @Data
    public static class HotelOrderInfo {
        private String name;
        private String address;
        private String phone;

        private String checkInBeginTime;
        private String checkInEndTime;
        private String checkOutTime;
        private String documentUrl;
        private String imageUrlTemplate;

        @JsonFormat(pattern = "yyyy-MM-dd")
        private LocalDate checkInDate;
        @JsonFormat(pattern = "yyyy-MM-dd")
        private LocalDate checkOutDate;
    }

    @Data
    public static class TrainOrderInfo {
        private String stationFromId;
        private String stationToId;
        private String trainStartSettlementTitle;
        private String trainEndSettlementTitle;
        private Instant departure;
        private Instant arrival;

        private String trainNumber;
        private String brandTitle;
        private String carNumber;
        private String carType;
        private String compartmentGender;
        private List<String> placeNumbers;
    }
}

