# Структура обмена данными о заказе между travel api и notifier

`UUID orderId;` - ID заказа, передаваемый в параметре запроса; notifier его уже знает, но проще иметь этот номер в структуре для полноты картины; используется для формирования ссылки кнопки "скачать билет" поездного заказа -
см. https://st.yandex-team.ru/RASPTICKETS-20321#603fa0d962c8bf6c69aec70a

`String prettyId;` - pretty ID

`List<HotelOrderInfo> hotelOrderInfos;`
`List<TrainOrderInfo> trainOrderInfos;` - нотифаер уже знает тип заказа, когда идёт за информацией в эту ручку;
если тип заказа на самом деле другой, этому уже не помочь - но нотифаер может делать sanity check проверки
на непустоту строк / валидность дат, чтобы не отправлять письмо, если нужная структура не заполнена;
когда/если будем переделывать на ручку, возвращающую всю информацию о заказе (т.е. включая и BasicOrderInfo
https://a.yandex-team.ru/arc/trunk/arcadia/travel/orders/proto/services/orders/basic_info/v1/basic_info.proto?rev=r7936533#L17 ),
нужно будет сделать отдельное enum-поле с типом заказа, конечно же; сейчас лучше положиться на тип заказа из нотифаера,
чтобы не плодить сущности, а sanity-проверки данных на стороне нотифаера всё равно нужны

Списки, а не просто структуры, сделаны для упрощения в будущем поддержки заказов вида жд+жд
и других составных заказов - пока предполагается, что нотифаер будет проверять,
что длина списка равна единице, и считать список невалидным при большей длине.

## `HotelOrderInfo`

`String name;` - тайтл отеля; в заказе таких полей два - в `basicHotelInfo` и в `legalHotelInfo`, сейчас заполняется из `basicHotelInfo`, но нет уверенности, какие есть гарантии в оркестраторе по заполненности двух возможных источников тайтла;

`String address;` - аналогично, из двух возможных источников адреса (`basicHotelInfo` и `legalHotelInfo`) сейчас используется
`basicHotelInfo` - в данном случае потому, что юридический адрес отеля (если `legalHotelInfo` - это он, уверенности нет)
может не совпадать с физическим адресом; нотифаеру нужен физический адрес; рендерер хочет к адресу отеля ещё и ссылку на location -
не делаем сейчас эту ссылку, обсуждали тут: https://st.yandex-team.ru/RASPTICKETS-20319#6041d9158a324b26092c974b

`String phone;` - телефон гостиницы; сейчас в макете рендерера нет места куда его засунуть, но по опыту путешествий -
это единственное, что обязательно нужно иметь путешественнику с собой, кроме названия и адреса (например, так можно узнать
как проехать к гостинице, если навигатор тупит), так что добавлю сюда на всякий случай

`String checkInBeginTime;` - время начала заселения, например `"13:00"`
`String checkInEndTime;` - время окончания заселения, например `"23:00"`
в этих двух полях (глазами видел только во втором, то, что в первом так может быть - это гипотеза) может встречаться специальное
значение "в любое время"; соответственно, нотифаер должен проверять содержимое поле на это значение, чтобы не получить строку вида
`"Заезд с 13:00 до в любое время"`.

`String checkOutTime;` - время, до которого нужно выехать, например `"13:00"` (надо бы или уточнить, возможно ли в этом поле
спецзначение "в любое время", или просто для единообразия проверить на это значение на стороне нотифаера); интересно, есть ли
другие спецзначения

`String documentUrl;` - ссылка на скачиваемый ваучер; в некоторых заказах здесь `null`;
`String imageUrl;` - ссылка на шаблон ссылки на картинку для показа в блоке информации о заказе;
```
обсуждение тут: https://yndx-travel.slack.com/archives/C01FY7RUAP2/p1615381787074900
пример шаблона: "https://avatars.mds.yandex.net/get-altay/492546/2a0000015e70f2fcfce73b7d756e49f415e8/%s"

допустимые размеры:
XXXS - 50px
XXS - 75px
XS - 100px
S - 150px
M - 300px
L - 500px
XL - 800px
XXL - 1024px
XXXL - 1280px (not sure)
orig - оригинальный размер
это указана ширина, высота будет зависеть от пропорций картинки

выбор размера проводим на стороне нотифаера, чтобы иметь возможность оперативно поменять, если вдруг вёрстка письма разъедется.
```


`LocalDate checkInDate;` - дата заезда
`LocalDate checkOutDate;` - дата выезда


## `TrainOrderInfo`

`String stationFromId;` - код станции отправления первого сегмента поездки, например `2000003` (может не совпадать с пунктом отправления поезда)

`String stationToId;` - код станции прибытия последнего сегмента поездки, например `9602494` (может не совпадать с пунктом прибытия поезда)

`String trainStartSettlementTitle;` - название города (settlement) отправления поезда; сейчас его не просят писать, но на
поезда дальнего следования часто ссылаются по их концевым точкам, поэтому может понадобиться; лучше бы, конечно, ID, но его
в заказе не нашёл

`String trainEndSettlementTitle;` - название города (settlement) конечной станции маршрута поезда (не пассажира);

пример: поездка `Екатеринбург - Тюмень` запросто может быть на поезде `Москва - Новый Уренгой`. В этом случае значения полей
будут такими:
stationFromId - код станции Екатеринбург-Пасс
stationToId - код станции Тюмень
trainStartSettlementTitle - строка "Москва"
trainEndSettlementTitle - строка "Новый Уренгой"

`Instant departure;` - время отправления; чтобы получить локальное время для вставки в письмо, это время нужно перевести в часовую зону сеттлмента отправления

`Instant arrival;` - время прибытия; чтобы получить локальное время для вставки в письмо, это время нужно перевести в часовую зону сеттлмента прибытия; сеттлмент прибытия вычисляется через станцию по единым справочникам

`String trainNumber;` - номер поезда, например "16Ф"; может начинаться с нулей, например "008С"; не знаю, нужно ли перед рендерингом обрезать эти нули

`String brandTitle;` - название поезда, если есть (может не быть, надо проверить, не съедет ли рендеринг в этом случае)

`String carNumber;` - номер вагона, может начинаться с нуля, например, "02" - второй вагон

`String carType;` - тип вагона, например "platzkarte"; скорее всего, типы перечислены здесь, но не проверял: https://a.yandex-team.ru/arc/trunk/arcadia/travel/api/src/main/java/ru/yandex/travel/api/models/train/TrainOrderMaps.java?rev=r7948853#L56

`String compartmentGender;` - тип купе, если есть (мужское, женское, смешанное); список типов, насколько понял, тут, но это предположение: https://a.yandex-team.ru/arc/trunk/arcadia/travel/rasp/library/java/train-parsers/src/main/java/ru/yandex/travel/train/model/CabinGenderKind.java
не знаю, пишется ли male/female/mixed целиком, или обозначается одной буквой M/F/""

`List<String>` placeNumbers - номера мест пассажиров, например ["08", "11", "52А"]; "52А" - это гипотеза, не нашёл навскидку
заказов, где номера были бы с буквами, но насколько помню российские поезда, что-то такое там было
