package ru.yandex.travel.api.services.orders.user_info;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.orders.client.HAGrpcChannelFactory;
import ru.yandex.travel.orders.user_info.proto.UserInfoInterfaceV1Grpc;

@Configuration
@EnableConfigurationProperties(UserInfoGrpcProperties.class)
public class UserInfoGrpcServiceConfiguration {
    @Bean
    public UserInfoGrpcClientFactory userInfoGrpcClientFactory(@Qualifier("OrchestratorGrpcChannelFactory") HAGrpcChannelFactory haGrpcChannelFactory) {
        return () -> UserInfoInterfaceV1Grpc.newFutureStub(haGrpcChannelFactory.getFastestChannel());
    }

    @Bean
    public UserInfoGrpcService userInfoGrpcService(UserInfoGrpcClientFactory userInfoGrpcClientFactory,
                                                   UserInfoGrpcProperties userInfoGrpcProperties,
                                                   Retry retryHelper) {
        return new UserInfoGrpcService(userInfoGrpcClientFactory, userInfoGrpcProperties, retryHelper);
    }
}
