package ru.yandex.travel.api.services.promo;

import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.endpoints.promo.req_rsp.UserPromoAttributesRspV1;
import ru.yandex.travel.api.services.orders.OrchestratorClientFactory;
import ru.yandex.travel.orders.proto.TUserPromoAttributesReq;

import static ru.yandex.travel.commons.concurrent.FutureUtils.buildCompletableFuture;

@Service
@RequiredArgsConstructor
public class UserPromoAttributesService {

    private final OrchestratorClientFactory orchestratorClientFactory;

    public CompletableFuture<UserPromoAttributesRspV1> getUserPromoAttributes() {
        return buildCompletableFuture(orchestratorClientFactory.createRoundRobinStubPromoCodeStub()
                .userPromoAttributes(TUserPromoAttributesReq.newBuilder().build()))
                .thenApply(res -> {
                    UserPromoAttributesRspV1 result = new UserPromoAttributesRspV1();
                    result.setFirstOrderPromoCodeEligible(res.getFirstOrderPromoEligible());
                    return result;
                });
    }
}
