package ru.yandex.travel.api.services.seo;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.proto.seo.TSeoExpListElement;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(SeoExperimentsDataProviderProperties.class)
    public class SeoExperimentsDataProviderConfiguration {

    @Bean
    public SeoExperimentsDataProvider seoExperimentDataProvider(SeoExperimentsDataProviderProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TSeoExpListElement> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TSeoExpListElement>()
                .setProtoClass(TSeoExpListElement.class);

            return new SeoExperimentsService(params, luceneIndexBuilder);
        } else {
            return new DummySeoExperimentsDataProvider();
        }
    }
}
