package ru.yandex.travel.api.services.seo;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;

import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.yt_lucene_index.SwitchableYtLuceneIndexParams;

@ConfigurationProperties(value = "seo-experiments", ignoreUnknownFields = false)
@Validated
@Data
@EqualsAndHashCode(callSuper = true)
public class SeoExperimentsDataProviderProperties extends SwitchableYtLuceneIndexParams {
    private boolean enabled;

    private Map<String, SeoExperimentsDataProviderProperties.ExperimentSettings> experiments = Map.of();

    @Data
    @Validated
    public static class ExperimentSettings {
        @NotNull
        private SeoExperimentsElement element;
        @NotNull
        private SeoExperimentsOption option;
        private Optional<ZonedDateTime> start;
        private Optional<ZonedDateTime> stop;

        // For Kotlin
        public SeoExperimentsElement getElement() {
            return element;
        }

        public void setElement(SeoExperimentsElement element) {
            this.element = element;
        }

        public SeoExperimentsOption getOption() {
            return option;
        }

        public void setOption(SeoExperimentsOption option) {
            this.option = option;
        }

        public Optional<ZonedDateTime> getStart() {
            return start;
        }

        public void setStart(Optional<ZonedDateTime> start) {
            this.start = start;
        }

        public Optional<ZonedDateTime> getStop() {
            return stop;
        }

        public void setStop(Optional<ZonedDateTime> stop) {
            this.stop = stop;
        }
    }

    // For Kotlin
    public Map<String, ExperimentSettings> getExperiments() {
        return experiments;
    }

    public void setExperiments(Map<String, ExperimentSettings> experiments) {
        this.experiments = experiments;
    }
}
