
package ru.yandex.travel.api.services.subscriptions;

import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.api.endpoints.subscriptions.req_rsp.SubscribeOnBetterPriceReqV1;
import ru.yandex.travel.api.endpoints.subscriptions.req_rsp.SubscribeReqV1;
import ru.yandex.travel.api.endpoints.subscriptions.req_rsp.SubscriptionPromoConfigReqV1;
import ru.yandex.travel.api.endpoints.subscriptions.req_rsp.SubscriptionPromoConfigRspV1;
import ru.yandex.travel.api.endpoints.subscriptions.req_rsp.SubscriptionStatusReqV1;
import ru.yandex.travel.api.endpoints.subscriptions.req_rsp.SubscriptionStatusRspV1;
import ru.yandex.travel.commons.http.CommonHttpHeaders;

public interface NotifierSubscriptionService {
    CompletableFuture<Void> subscribe(SubscribeReqV1 request, CommonHttpHeaders commonHttpHeaders);

    CompletableFuture<Void> unsubscribe(String hash);

    CompletableFuture<SubscriptionStatusRspV1> getStatus(SubscriptionStatusReqV1 request);

    CompletableFuture<SubscriptionPromoConfigRspV1> getPromoConfig(SubscriptionPromoConfigReqV1 request,
                                                                   CommonHttpHeaders commonHttpHeaders);

    CompletableFuture<Void> subscribeOnBetterPrice(SubscribeOnBetterPriceReqV1 request);
}
