package ru.yandex.travel.api.services.subscriptions.model.better_price_subscription;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

@AllArgsConstructor
@Getter
@Builder(toBuilder = true)
@JsonDeserialize(builder = Flight.FlightBuilder.class)
public class Flight {
    @NotNull
    private Integer fromStationId;
    @NotNull
    private Integer toStationId;
    @NotNull
    private String localDepartureDatetime;
    @NotNull
    private String companyCode;
    @NotNull
    private String number;

    @JsonPOJOBuilder(withPrefix = "")
    public static class FlightBuilder {
    }
}
