package ru.yandex.travel.api.services.subscriptions.model.better_price_subscription;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

@AllArgsConstructor
@Getter
@Builder(toBuilder = true)
@JsonDeserialize(builder = Price.PriceBuilder.class)
public class Price {
    @NotNull
    private Double value;
    @NotNull
    private String currency;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PriceBuilder {
    }
}
