package ru.yandex.travel.api.services.subscriptions.model.better_price_subscription;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

@AllArgsConstructor
@Getter
@Builder(toBuilder = true)
@JsonDeserialize(builder = Tariff.TariffBuilder.class)
public class Tariff {
    private Price price;
    private Price exchangedPrice;

    @JsonPOJOBuilder(withPrefix = "")
    public static class TariffBuilder {
    }
}
