package ru.yandex.travel.api.services.subscriptions.model.better_price_subscription;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

@AllArgsConstructor
@Getter
@Builder(toBuilder = true)
@JsonDeserialize(builder = Variant.VariantBuilder.class)
public class Variant {
    private List<Flight> forwardFlights;
    private List<Flight> backwardFlights;

    @JsonPOJOBuilder(withPrefix = "")
    public static class VariantBuilder {
    }
}
