package ru.yandex.travel.api.services.train;

import io.opentracing.Tracer;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.train.partners.im.ImClient;
import ru.yandex.travel.train.partners.im.ImClientConfigurationHelper;
import ru.yandex.travel.train.partners.im.ImProperties;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties({ImClientApiConfiguration.ImPropertiesImpl.class})
public class ImClientApiConfiguration {
    private final ImClientApiConfiguration.ImPropertiesImpl imProperties;
    private final Tracer tracer;

    @Bean
    public AsyncHttpClientWrapper imAhcClient() {
        return ImClientConfigurationHelper.createImAhcClient(tracer);
    }

    @Bean
    public ImClient imClient(AsyncHttpClientWrapper imAhcClient) {
        return ImClientConfigurationHelper.createImClient(imProperties, imAhcClient, null);
    }

    @Validated
    @ConfigurationProperties(value = "im", ignoreUnknownFields = false)
    public static class ImPropertiesImpl extends ImProperties {}
}
