package ru.yandex.travel.api.services.train;

public class TrainApiException extends RuntimeException {
    private int statusCode;
    private Object content;

    public TrainApiException(String message, Throwable cause, int statusCode, Object content) {
        super(message, cause);
        this.statusCode = statusCode;
        this.content = content;
    }

    public TrainApiException(String message, int statusCode, Object content) {
        this(message, null, statusCode, content);
    }

    public TrainApiException(Throwable cause, int statusCode, Object content) {
        this(null, cause, statusCode, content);
    }
}
