package ru.yandex.travel.api.services.train;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "train-api", ignoreUnknownFields = false)
@Validated
@Data
public class TrainApiProperties {
    @NotEmpty
    private String baseUrl;
    @NotEmpty
    private String tvmAlias;
    @NotNull
    private Duration httpReadTimeout;
    @NotNull
    private Duration httpRequestTimeout;
}
