package ru.yandex.travel.api.services.train;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.config.train.OfferStorageApiConfiguration;
import ru.yandex.travel.commons.concurrent.FutureUtils;
import ru.yandex.travel.train_offer_storage.proto.OfferStorageApiServiceV1Grpc;
import ru.yandex.travel.train_offer_storage.proto.TGetOfferRequest;
import ru.yandex.travel.train_offer_storage.proto.TGetOfferResponse;
import ru.yandex.travel.trains.proto.TTrainServiceOffer;

@Service
@Slf4j
@RequiredArgsConstructor
public class TrainOfferService {
    private final OfferStorageApiConfiguration.TrainOfferClientFactory clientFactory;

    public CompletableFuture<TTrainServiceOffer> get(UUID offerId) {
        TGetOfferRequest request = TGetOfferRequest.newBuilder().setOfferId(offerId.toString()).build();
        OfferStorageApiServiceV1Grpc.OfferStorageApiServiceV1FutureStub stub = clientFactory.createStub();
        return FutureUtils.buildCompletableFuture(stub.getOffer(request)).thenApply(TGetOfferResponse::getOffer);
    }

}
