package ru.yandex.travel.api.services.train;

import java.time.ZonedDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrainProxyOrderDTO {
    private boolean insuranceAutoReturn;
    private String status;
    private String uid; // TODO (mbobrov): find out if it's a real uid
    private ZonedDateTime maxPendingTill;
    private String trainTitle;
    private String brandTitle;
    private String carType;
    private String compartmentGender;
    private ZonedDateTime departure; // TODO (mbobrov): get timezone
    private boolean isSuburban;
    private String gender; // TODO (mbobrov): what to expect
    private String partner;
    private String insuranceStatus; //TODO (mbobrov): what to expect
    private String carNumber;
    private String error;
    private String trainTicketNumber; // TODO (mbobrov): wut?
    private String orderNumber;
    private ZonedDateTime reservedTo;
    private String rebookingAvailable;
    private String specialNotice;
    private String timeNotice;
    private TrainProxyOrderStationDTO stationTo;
    private boolean insuranceEnabled;
    private ZonedDateTime arrival; // TODO (mbobrov): timestamp
    private boolean isOnlyFullReturnPossible;
    private TrainProxyOrderStatus travelStatus; // TODO (mbobrov): to enum
    private boolean twoStorey;
    private String paymentUrl;
    private TrainProxyOrderUserInfo userInfo;
    private String paymentCode;
    private String paymentReceiptUrl;
    private String trainNumber;
    private List<TrainProxyOrderPassengerInfo> passengers;
    private JsonNode refundPayments;
    private String paymentStatus;
    private boolean isReservationProlonged;
    private TrainProxyOrderStationDTO stationFrom;
    private TrainProxyOrderStationDTO startStation;
    private TrainProxyOrderStationDTO endStation;
    private ZonedDateTime ticketsStatusFreezesAt;
    private String coachOwner;
}
