package ru.yandex.travel.api.services.train;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum TrainProxyOrderStatus {
    RESERVED("Reserved"), IN_PROGRESS("In progress"), DONE("Done"), CANCELLED("Cancelled"), UNKNOWN("Unknown");

    private final String value;

    @JsonCreator
    public static TrainProxyOrderStatus fromString(String val) {
        for (TrainProxyOrderStatus candidate : TrainProxyOrderStatus.values()) {
            // TODO (mbobrov): find out if we can fix the case here
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum TrainProxyOrderStatus", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
