package ru.yandex.travel.api.services.train.search

import ru.yandex.travel.commons.concurrent.FutureUtils
import ru.yandex.travel.trains.search_api.api.Request
import ru.yandex.travel.trains.search_api.api.Response
import ru.yandex.travel.trains.search_api.api.price_calendar.PriceCalendarRequest
import ru.yandex.travel.trains.search_api.api.price_calendar.PriceCalendarResponse
import ru.yandex.travel.trains.search_api.api.seo_direction.SeoDirectionRequest
import ru.yandex.travel.trains.search_api.api.seo_direction.SeoDirectionResponse
import java.util.concurrent.CompletableFuture

class TrainSearchServiceImpl(
    private val trainSearchServiceStubFactory: TrainSearchServiceStubFactory,
) : TrainSearchService {

    override fun search(request: Request): CompletableFuture<Response> =
        FutureUtils.buildCompletableFuture(trainSearchServiceStubFactory.createRoundRobinStub().search(request))

    override fun direction(request: SeoDirectionRequest): CompletableFuture<SeoDirectionResponse> =
        FutureUtils.buildCompletableFuture(trainSearchServiceStubFactory.createRoundRobinStub().seoDirection(request))

    override fun priceCalendar(request: PriceCalendarRequest): CompletableFuture<PriceCalendarResponse> =
        FutureUtils.buildCompletableFuture(trainSearchServiceStubFactory.createRoundRobinStub().priceCalendar(request))
}
