package ru.yandex.travel.api.services.train.search

import java.time.Duration
import javax.validation.Valid
import javax.validation.constraints.NotEmpty
import javax.validation.constraints.NotNull
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.validation.annotation.Validated
import ru.yandex.travel.orders.client.FailureDetectorProperties
import ru.yandex.travel.orders.client.GrpcChannelSupplierMode
import ru.yandex.travel.orders.client.GrpcChannelSupplierProperties
import ru.yandex.travel.orders.client.yp.YpDiscoveryProperties

@Validated
@ConfigurationProperties(prefix = "train-search-service", ignoreUnknownFields = false)
open class TrainSearchServiceProperties : GrpcChannelSupplierProperties {
    @field:NotNull
    open var timeout: Duration? = null

    @field:NotNull
    open var failureDetection: FailureDetectorProperties? = null

    @field:Valid
    open var tvm: Tvm? = null

    @Validated
    open class Tvm {
        open var enabled = false

        @field:NotEmpty
        open var destinationAlias: String? = null
    }

    private var yp: YpDiscoveryProperties? = null
    private var targets: List<String>? = null
    private var mode: GrpcChannelSupplierMode? = null

    // Workaround for Java compatibility issue https://youtrack.jetbrains.com/issue/KT-6653

    @Valid
    override fun getYp() = yp
    open fun setYp(ypValue: YpDiscoveryProperties) {
        yp = ypValue
    }

    @Valid
    override fun getTargets() = targets
    open fun setTargets(targetsValue: List<String>) {
        targets = targetsValue
    }

    @Valid
    override fun getMode() = mode
    open fun setMode(modeValue: GrpcChannelSupplierMode) {
        mode = modeValue
    }
}
