package ru.yandex.travel.api.services.trust;

import io.opentracing.Tracer;
import org.asynchttpclient.AsyncHttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.orders.services.payments.BasicTrustConfiguration;
import ru.yandex.travel.orders.services.payments.DefaultTrustClient;
import ru.yandex.travel.orders.services.payments.TrustClient;
import ru.yandex.travel.orders.services.payments.TrustConnectionProperties;

import static ru.yandex.travel.api.config.common.AhcConfiguration.DEFAULT_HTTP_LOGGER;

@Configuration
@EnableConfigurationProperties({
        TrustConnectionProperties.class,
})
public class TrustConfiguration {
    @Bean
    @ConfigurationProperties(value = "trust-plus", ignoreUnknownFields = false)
    public BasicTrustConfiguration trustProperties() {
        return new BasicTrustConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean
    public TrustClient defaultTrustClient(
            @Qualifier("trustAsyncClientWrapper") AsyncHttpClientWrapper httpClient,
            TrustConnectionProperties trustConnectionProperties,
            BasicTrustConfiguration trustProperties
    ) {
        return new DefaultTrustClient(httpClient, trustConnectionProperties, trustProperties.getServiceToken());
    }

    @Bean
    public AsyncHttpClientWrapper trustAsyncClientWrapper(AsyncHttpClient defaultAhcClient,
                                                          Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "trust", tracer,
                DefaultTrustClient.Method.getNames());
    }
}
