package ru.yandex.travel.api.services.weather;

import java.time.Month;
import java.util.HashMap;
import java.util.Map;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.models.Linguistics;
import ru.yandex.travel.api.services.weather.model.LinguisticCase;

@Component
@RequiredArgsConstructor
public class MonthDisplayNameProvider {

    final Map<Month, Linguistics> linguisticsMap = new HashMap<>() {
        {
            put(Month.JANUARY, buildMonthLinguistics(
                    "январь",
                    "января",
                    "январе"));

            put(Month.FEBRUARY, buildMonthLinguistics(
                    "февраль",
                    "февраля",
                    "феврале"));

            put(Month.MARCH, buildMonthLinguistics(
                    "март",
                    "марта",
                    "марте"));

            put(Month.APRIL, buildMonthLinguistics(
                    "апрель",
                    "апреля",
                    "апреле"));

            put(Month.MAY, buildMonthLinguistics(
                    "май",
                    "мая",
                    "мае"));

            put(Month.JUNE, buildMonthLinguistics(
                    "июнь",
                    "июня",
                    "июне"));

            put(Month.JULY, buildMonthLinguistics(
                    "июль",
                    "июля",
                    "июле"));

            put(Month.AUGUST, buildMonthLinguistics(
                    "август",
                    "августа",
                    "августе"));

            put(Month.SEPTEMBER, buildMonthLinguistics(
                    "сентябрь",
                    "сентября",
                    "сентябре"));

            put(Month.OCTOBER, buildMonthLinguistics(
                    "октябрь",
                    "октября",
                    "октябре"));

            put(Month.NOVEMBER, buildMonthLinguistics(
                    "ноябрь",
                    "ноября",
                    "ноябре"));

            put(Month.DECEMBER, buildMonthLinguistics(
                    "декабрь",
                    "декабря",
                    "декабре"));
        }
    };

    public Linguistics getLinguistics(Month month) {
        return linguisticsMap.get(month);
    }

    public String getDisplayName(Month month, LinguisticCase linguisticCase) {
        return getLinguisticForm(linguisticsMap.get(month), linguisticCase);
    }

    private String getLinguisticForm(Linguistics linguistics, LinguisticCase linguisticCase) {
        switch (linguisticCase) {
            case NOMINATIVE: return linguistics.getNominativeCase();
            case GENITIVE: return linguistics.getGenitiveCase();
            case DATIVE: return linguistics.getDativeCase();
            case LOCATIVE: return linguistics.getLocativeCase();
            case ABLATIVE: return linguistics.getAblativeCase();
            case ACCUSATIVE: return linguistics.getAccusativeCase();
            case DIRECTIONAL: return linguistics.getDirectionalCase();
            case INSTRUMENTAL: return linguistics.getInstrumentalCase();
            case PREPOSITIONAL: return linguistics.getPrepositionalCase();
            default: throw new RuntimeException("unexpected linguistics case");
        }
    }

    private Linguistics buildMonthLinguistics(String nominativeCase, String genitiveCase, String prepositionalCase) {
        var l = new Linguistics();
        l.setNominativeCase(nominativeCase);
        l.setGenitiveCase(genitiveCase);
        l.setPrepositionalCase(prepositionalCase);
        l.setPreposition("в");
        return l;
    }
}
