package ru.yandex.travel.api.services.weather;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.commons.http.apiclient.HttpApiPropertiesBase;

@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Data
@Validated
@ConfigurationProperties(value = "weather")
public class WeatherServiceProperties extends HttpApiPropertiesBase {
    @NotEmpty
    private String tvmAlias;
    @NotNull
    private Boolean tvmEnabled;
}
