package ru.yandex.travel.api.services.weather.model;

import java.time.LocalDate;
import java.time.Month;
import java.util.List;

import lombok.Builder;
import lombok.Data;

@Builder
@Data
public class WeatherByGeoIdData {
    public String url;
    public List<ForecastItem> forecastItems;
    public List<ClimateItem> climateItems;

    @Builder
    @Data
    public static class ForecastItem {
        private LocalDate date;
        private Integer humidity;
        private Integer waterTemperature;
        private Integer temperature;
        private Integer minTemperature;
        private String icon;
    }

    @Builder
    @Data
    public static class ClimateItem {
        private Month month;
        private Integer minNightTemperature;
        private Integer maxDayTemperature;
        private Integer precipitationDays;
        private Integer overcastDays;
        private Integer humidity;
        private Integer waterTemperature;
    }
}
