package ru.yandex.travel.api.services.weather.model;

import java.util.List;

import lombok.Data;

@Data
public class WeatherByGeoIdGraphQLData {
    public WeatherBlock weatherByGeoId;

    @Data
    public static class WeatherBlock {
        public String url;
        public Forecast forecast;
        public Climate climate;
    }

    @Data
    public static class Forecast {
        public List<ForecastDay> days;
    }

    @Data
    public static class ForecastDay {
        public Summary summary;
    }

    @Data
    public static class Summary {
        public SummaryDay day;
    }

    @Data
    public static class SummaryDay {
        private Integer humidity;
        private Integer waterTemperature;
        private Integer temperature;
        private Integer minTemperature;
        private String icon;
    }

    @Data
    public static class Climate {
        public List<ClimateMonth> months;
    }

    @Data
    public static class ClimateMonth {
        private Integer minNightTemperature;
        private Integer maxDayTemperature;
        private Integer precDays;
        private Integer overcastDays;
        private Integer humidity;
        private Integer waterTemperature;
    }
}
