RECURSE(
    src/test
)
JAVA_PROGRAM(travel-api)

JDK_VERSION(11)
WITH_KOTLIN()
INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)
OWNER(
    g:travel-hotels
    g:travel
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)
JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/travel/hotels/devops/resources **/*)

EXCLUDE(
    contrib/java/dom4j/dom4j
)

PEERDIR(
    travel/avia/library/java/booking-api-dtos
    travel/avia/library/java/booking-providers
    travel/api/proto/bizdev_admin
    travel/api/proto/crosslinks
    travel/api/proto/happy_page
    travel/api/proto/hotels_portal
    travel/api/proto/orders
    travel/api/proto/portal_recipes
    travel/api/proto/seo
    travel/api/proto/serp
    travel/api/spec
    travel/api/src/main/c/inflector
    travel/hotels/lib/java/busbroker
    travel/hotels/lib/java/partner_parsers
    travel/hotels/lib/java/models
    travel/hotels/proto2
    travel/hotels/proto/extranet_api
    travel/hotels/proto/geocounter_service
    travel/hotels/proto/hotel_filters
    travel/hotels/proto/hotel_filters_config
    travel/hotels/proto/tugc_service
    travel/hotels/proto/offercache_api
    travel/hotels/proto/offercache_grpc
    travel/hotels/proto/promo_service
    travel/hotels/proto/region_pages
    travel/hotels/proto/suggest
    travel/hotels/proto/bronevik
    travel/hotels/proto/promogranter_service
    travel/library/java/ha-grpc-client
    travel/library/java/ha-grpc-client-spring-configuration
    travel/library/java/logging-ydb
    travel/library/java/natives
    travel/library/java/promo-service-booking-flow
    travel/library/java/promo-service-client
    travel/library/java/takeout
    travel/library/java/trust-client
    travel/library/java/spring-boot-skeleton
    travel/library/java/workflow_proto
    travel/library/java/yt-lucene-index
    travel/hotels/lib/java/partner_config
    travel/hotels/lib/java/geosearch

    travel/orders/proto
    travel/orders/proto/services/orders
    travel/orders/proto/services/orders/admin
    travel/orders/proto/services/orders/cpa
    travel/orders/proto/services/orders/idm
    travel/orders/proto/services/orders/no_auth
    travel/orders/proto/services/orders/user_info
    travel/orders/proto/services/takeout

    travel/hotels/hotels_administrator/proto

    travel/proto/avia/country_restrictions
    travel/proto/base_types
    travel/proto/dicts/avia
    travel/proto/trains
    travel/proto/seo_pages
    travel/proto/cpa/tours
    travel/rasp/train_offer_storage/proto
    travel/rasp/library/java/train-parsers
    travel/rasp/library/java/bus-parsers
    travel/rasp/library/java/suburban
    travel/buses/backend/proto/api
    travel/trains/search_api/api
    travel/trains/search_api/api/seo_direction
    travel/proto/dicts/rasp
    travel/hotels/tools/gen_logfeller_parser_pojo/lib

    travel/notifier/api/subscriptions/v1
    travel/komod/library/java/trips-common
    travel/komod/trips/api/trips/v1
    travel/avia/personalization/api/personal_search/v2

    kernel/ugc/proto

    maps/doc/proto/yandex/maps/proto/atom
    maps/doc/proto/yandex/maps/proto/common2
    maps/doc/proto/yandex/maps/proto/photos
    maps/doc/proto/yandex/maps/proto/search

    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml
    contrib/java/com/fasterxml/jackson/module/jackson-module-kotlin/2.9.7
    contrib/java/com/hubspot/jackson/jackson-datatype-protobuf/0.9.12
    contrib/java/ma/glasnost/orika/orika-core
    contrib/java/org/asynchttpclient/async-http-client
    contrib/java/org/caffinitas/ohc/ohc-core/0.7.0
    contrib/java/org/apache/logging/log4j/log4j-jcl
    contrib/java/org/ehcache/ehcache/3.7.1
    contrib/java/org/jetbrains/kotlin/kotlin-reflect
    contrib/java/org/springframework/boot/spring-boot-starter-web
    contrib/java/org/springframework/boot/spring-boot-starter-jdbc
    contrib/java/org/springframework/boot/spring-boot-starter-validation
    contrib/java/io/springfox/springfox-swagger2
    contrib/java/io/springfox/springfox-swagger-ui
    contrib/java/joda-time/joda-time
    contrib/java/javax/xml/bind/jaxb-api
    contrib/java/com/github/ben-manes/caffeine/caffeine
    contrib/java/com/google/protobuf/protobuf-java-util

    contrib/java/io/sentry/sentry-spring

    contrib/java/org/apache/lucene/lucene-core
    contrib/java/org/apache/lucene/lucene-analyzers-common
    contrib/java/org/apache/lucene/lucene-queryparser

    iceberg/inside-geobase
    iceberg/inside-yt
    travel/hotels/lib/java/commons

    contrib/java/com/h2database/h2
    contrib/java/org/postgresql/postgresql

    contrib/libs/grpc/src/proto/grpc/health/v1

    kikimr/persqueue/sdk/java/v0

    logbroker/unified_agent/client/java/log4j2
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/api.py
    CUSTOM_PROPERTY appName travel-api
    CUSTOM_PROPERTY mainClass ru.yandex.travel.api.Application
)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/ma/glasnost/orika/orika-core/1.5.2
    contrib/java/joda-time/joda-time/2.10.5
)

CHECK_DEPENDENT_DIRS(
    DENY
)

LINT(base)
END()


RECURSE(
    grpc_gateway
)
