PROTO_LIBRARY()

OWNER(g:travel-app-backend)

SRCS(
    common.proto
    hotels.proto
    hotels_api.proto
    offers.proto
    reviews.proto
)

GRPC()

USE_COMMON_GOOGLE_APIS(
    api/annotations
    type/date
)

PEERDIR(
    travel/app/backend/api/common/v1
    travel/app/backend/api/commonorder/v1
)

IF (GO_PROTO)
    SET_APPEND(
        PROTO_PATH
        -I
        ${ARCADIA_ROOT}/vendor/github.com/grpc-ecosystem/grpc-gateway
    )

    ADDINCL(${ARCADIA_ROOT}/vendor/github.com/grpc-ecosystem/grpc-gateway)

    GO_GRPC_GATEWAY_SWAGGER_SRCS(hotels_api.proto)

    RESOURCE(
        hotels_api.swagger.json hotels_api.swagger.json
    )
ENDIF()

END()
