# Утилита обновления данных локализации

Выкачивает все кейсеты проекта [travel-app](https://tanker.yandex-team.ru/project/travel-app) из Танкера
используя метод [export](https://tanker-beta.yandex-team.ru/api/docs/?url=/api/v1/openapi.yaml#/export/exportProject)
и обнаруживает изменения по сравнению с предыдущей версией.

Для запуска требует параметра `--tanker-token`, в который необходимо передать OAuth-токен внутреннего пользователя,
из под которого будет сделан вызов в Танкер. Для ручных запусков токен можно взять, например, [здесь](https://nda.ya.ru/3SjQY7).

После выполнения генерирует выходной файл с содержимым проекта (имя файла задается параметром `--output-file`, по
умолчанию — `output.json`).

Может принимать на вход предыдущую версию данных: загружает их из файла, имя которого передается в параметр
`--last-released-revision-file`.

Если данные в Танкере изменились по сравнению с предыдущей версией (или если не был указан параметр
`--last-released-revision-file`), то генерит ещё и файл описания выходных ресурсов согласно
[спецификации таска TRAVEL_RUN_BINARY](https://docs.yandex-team.ru/travel/services/hotels/sandbox_planner#sozdanie-resursov).

## Регулярный автоматический запуск

Бинарник утилиты собран таском YA_MAKE2 и релизнут в stable. Соответствующий ресурс имеет имя `TRAVEL_APP_BACKEND_L10N_IMPORTER`,
его последняя версия доступа в сендбоксе по [этой ссылке](https://sandbox.yandex-team.ru/resources?type=TRAVEL_APP_BACKEND_L10N_IMPORTER&limit=1&offset=0&attrs=%7B%22released%22%3A%22stable%22%7D).
При необходимости внести изменение в логику работы нужно собрать и релезнуть новую версию. В будущем для этого
возможно использование Релизной Машины, пока же создание тасков и их релиз предполагается вручную.

Регулярный запуск самого процесса импорта настроен посредством [sandbox planner](https://docs.yandex-team.ru/travel/services/hotels/sandbox_planner).
Соответствующей plan-item имеет имя `l10n-importer` и может быть найден [здесь](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/devops/sandbox_planner/plan/app.yaml?rev=r8897691#L1).
Он каждые 15 минут запускает в sandbox таск `TRAVEL_RUN_BINARY`, который предоставляет необходимую машинерию для работы
с ресурсами sandbox: скачивает последнюю релизнутую версию утилиты, а так же  последнюю релизнутую версию ресурса
`TRAVEL_APP_BACKEND_L10N_DATA`, запускает утилиту с правильными параметрами, передавая ей на вход ресурс, после чего,
если утилита сгенерировала непустой файл описания выходных ресурсов, закачивает эти ресурсы в сендбокс и релизит их в
stable.

Таким образом, запуск задач выгрузки данных из танкера осуществляется каждые 15 минут, но сохранение этих данных в
сендбокс в виде ресурса случается только если очередная выгрузка отличается от последней сохраненной версии.

Наблюдать запуск этих задач можно в [Соломоне](https://solomon.yandex-team.ru/?project=travel&cluster=push_prod&service=sandbox&plan_id=l10n-importer&graph=travel-sandbox-run-status&b=1d).
Список последних выполненных задач доступен в сендбоксе по тэгу [PLAN_ID:L10N-IMPORTER](https://sandbox.yandex-team.ru/tasks?children=true&created=14_days&limit=20&tags=PLAN_ID%3AL10N-IMPORTER).

Релиз ресурса в stable приводит к созданию в окружениях Deploy тикета на обновление динамических ресурсов.
Соответствующий ресурс загружается в контейнер в файл на подмонтированном persisted volume, после чего машинерия Deploy
уведомляет запущенное приложение backend'а о необходимости пересчитать файл с данными локализации.
