package logs

import (
	"context"
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/app/backend/internal/common"
	"a.yandex-team.ru/travel/app/backend/internal/references"
	"a.yandex-team.ru/travel/library/go/geobase"
	"a.yandex-team.ru/travel/library/go/unifiedagent"
)

type AviaUsersSearchLogLogger struct {
	logger        log.Logger
	baseLogger    *BaseLogger
	geoBase       geobase.Geobase
	pointRegistry *references.Registry
}

func NewAviaUsersSearchLogLogger(logger log.Logger, uaClient unifiedagent.Client, geoBase geobase.Geobase, pointRegistry *references.Registry) *AviaUsersSearchLogLogger {
	return &AviaUsersSearchLogLogger{
		logger:        logger,
		baseLogger:    NewBaseLogger(logger, uaClient, "avia-users-search-log", geoBase, pointRegistry),
		geoBase:       geoBase,
		pointRegistry: pointRegistry,
	}
}

func (l *AviaUsersSearchLogLogger) Log(ctx context.Context, qid string) {
	logElement := make(map[string]interface{})

	logElement["service"] = []byte(common.ServiceName)
	logElement["unixtime"] = uint64(time.Now().Unix())

	logElement = l.baseLogger.SetQidData(logElement, qid)
	logElement = l.baseLogger.SetPlatformData(ctx, logElement)
	logElement = l.baseLogger.SetRealIPData(ctx, logElement)

	l.baseLogger.Log(logElement)
}
