package badges

import (
	"context"

	aviaApi "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
	"a.yandex-team.ru/travel/app/backend/internal/lib/aviatdapiclient"
	"a.yandex-team.ru/travel/avia/library/go/searchcontext"
)

type BaseBadgeObserverBuilder struct{}

func (b *BaseBadgeObserverBuilder) BuildToCache(
	_ context.Context,
	_ *AviaClients,
	_ *searchcontext.QID,
	_ *aviatdapiclient.SearchResultReference,
) ToCacheBadgeObserver {
	return &ToCacheBaseBadgeObserver{}
}

func (b *BaseBadgeObserverBuilder) BuildToResponse(
	_ context.Context,
	_ *AviaClients,
	_ *searchcontext.QID,
	_ aviaApi.SearchSort,
	_ *aviaSearchProto.Reference,
	_ *aviaSearchProto.CacheSnippetStats,
) ToResponseBadgeObserver {
	return &ToResponseBaseBadgeObserver{}
}

type ToCacheBaseBadgeObserver struct{}

func (pc *ToCacheBaseBadgeObserver) ObserveAllSnippets(snippets map[string]*aviaSearchProto.Snippet, cacheSnippetStats *aviaSearchProto.CacheSnippetStats) (map[string]*aviaSearchProto.Snippet, *aviaSearchProto.CacheSnippetStats) {
	return snippets, cacheSnippetStats
}

func (pc *ToCacheBaseBadgeObserver) ObserveRawVariant(variant *aviatdapiclient.SearchResultPrice, badges []*aviaSearchProto.Badge) []*aviaSearchProto.Badge {
	return badges
}

func (pc *ToCacheBaseBadgeObserver) ObserveSnippet(fare *aviatdapiclient.SearchResultFare, snippet *aviaSearchProto.Snippet) *aviaSearchProto.Snippet {
	return snippet
}

type ToResponseBaseBadgeObserver struct{}

func (t ToResponseBaseBadgeObserver) ObserveSnippet(snippet *aviaApi.Snippet, stats *SnippetStats) *aviaApi.Snippet {
	return snippet
}
