package badges

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	aviaApi "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
	"a.yandex-team.ru/travel/app/backend/internal/avia/search/searchcommon"
	"a.yandex-team.ru/travel/avia/library/go/searchcontext"
)

type BestPriceBadgeObserverBuilder struct {
	BaseBadgeObserverBuilder
	logger log.Logger
}

func NewBestPriceBadgeObserverBuilder(logger log.Logger) *BestPriceBadgeObserverBuilder {
	return &BestPriceBadgeObserverBuilder{
		logger: logger,
	}
}

func (b *BestPriceBadgeObserverBuilder) BuildToResponse(
	_ context.Context,
	_ *AviaClients,
	_ *searchcontext.QID,
	_ aviaApi.SearchSort,
	_ *aviaSearchProto.Reference,
	_ *aviaSearchProto.CacheSnippetStats,
) ToResponseBadgeObserver {
	return &ToResponseBestPriceBadgeObserver{}
}

type ToResponseBestPriceBadgeObserver struct{}

func (o *ToResponseBestPriceBadgeObserver) ObserveSnippet(snippet *aviaApi.Snippet, stats *SnippetStats) *aviaApi.Snippet {
	rrr := searchcommon.CheckOnlyPriceEqual(snippet.Variant.Price, stats.BestPrice)
	if rrr {
		snippet.Badges = append(snippet.Badges, &aviaApi.Snippet_Badge{Type: aviaApi.Snippet_BADGE_TYPE_BEST_PRICE})
	}

	return snippet
}
