package badges

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
	"a.yandex-team.ru/travel/app/backend/internal/lib/aviatdapiclient"
	"a.yandex-team.ru/travel/avia/library/go/searchcontext"
)

type BoyBadgeObserverBuilder struct {
	BaseBadgeObserverBuilder
	logger log.Logger
}

func NewBoyBadgeObserverBuilder(logger log.Logger) *BoyBadgeObserverBuilder {
	return &BoyBadgeObserverBuilder{
		logger: logger,
	}
}

func (b *BoyBadgeObserverBuilder) BuildToCache(
	_ context.Context,
	_ *AviaClients,
	_ *searchcontext.QID,
	_ *aviatdapiclient.SearchResultReference,
) ToCacheBadgeObserver {
	return &ToCacheBoyBadgeObserver{}
}

type ToCacheBoyBadgeObserver struct {
	ToCacheBaseBadgeObserver
}

func (pc *ToCacheBoyBadgeObserver) ObserveRawVariant(variant *aviatdapiclient.SearchResultPrice, badges []*aviaSearchProto.Badge) []*aviaSearchProto.Badge {
	if variant.Boy {
		badges = append(badges, &aviaSearchProto.Badge{
			Type:          aviaSearchProto.BadgeType_BADGE_TYPE_BOOK_ON_YANDEX,
			OptionalValue: nil,
		})
	}

	return badges
}
