package badges

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
	"a.yandex-team.ru/travel/app/backend/internal/lib/aviatdapiclient"
	"a.yandex-team.ru/travel/avia/library/go/searchcontext"
)

type CharterBadgeObserverBuilder struct {
	BaseBadgeObserverBuilder
	cfg    *PopularBadgeObserverBuilderConfig
	logger log.Logger
}

func NewCharterBadgeObserverBuilder(logger log.Logger) *CharterBadgeObserverBuilder {
	return &CharterBadgeObserverBuilder{
		logger: logger,
	}
}

func (b *CharterBadgeObserverBuilder) BuildToCache(
	ctx context.Context,
	clients *AviaClients,
	qid *searchcontext.QID,
	reference *aviatdapiclient.SearchResultReference,
) ToCacheBadgeObserver {
	return &ToCacheCharterBadgeObserver{}
}

type ToCacheCharterBadgeObserver struct {
	ToCacheBaseBadgeObserver
	isCharterPartners  int
	notCharterPartners int
}

func (pc *ToCacheCharterBadgeObserver) ObserveSnippet(fare *aviatdapiclient.SearchResultFare, snippet *aviaSearchProto.Snippet) *aviaSearchProto.Snippet {
	isCharterPartners := 0
	notCharterPartners := 0

	for _, variantRaw := range fare.Prices {
		if variantRaw.Charter {
			isCharterPartners += 1
		} else {
			notCharterPartners += 1
		}
	}

	if isCharterPartners > 0 {
		if notCharterPartners == 0 {
			snippet.Badges = append(snippet.Badges, &aviaSearchProto.Badge{
				Type:          aviaSearchProto.BadgeType_BADGE_TYPE_CHARTER,
				OptionalValue: nil,
			})
		} else {
			snippet.Badges = append(snippet.Badges, &aviaSearchProto.Badge{
				Type:          aviaSearchProto.BadgeType_BADGE_TYPE_SPECIAL_CONDITIONS,
				OptionalValue: nil,
			})
		}
	}

	return snippet
}
