package badges

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
	"a.yandex-team.ru/travel/app/backend/internal/lib/aviatdapiclient"
	"a.yandex-team.ru/travel/avia/library/go/searchcontext"
)

type FromCompanyBadgeObserverBuilder struct {
	BaseBadgeObserverBuilder
	logger log.Logger
}

func NewFromCompanyBadgeObserverBuilder(logger log.Logger) *FromCompanyBadgeObserverBuilder {
	return &FromCompanyBadgeObserverBuilder{
		logger: logger,
	}
}

func (b *FromCompanyBadgeObserverBuilder) BuildToCache(
	_ context.Context,
	_ *AviaClients,
	_ *searchcontext.QID,
	_ *aviatdapiclient.SearchResultReference,
) ToCacheBadgeObserver {
	return &ToCacheFromCompanyBadgeObserver{}
}

type ToCacheFromCompanyBadgeObserver struct {
	ToCacheBaseBadgeObserver
}

func (pc *ToCacheFromCompanyBadgeObserver) ObserveRawVariant(variant *aviatdapiclient.SearchResultPrice, badges []*aviaSearchProto.Badge) []*aviaSearchProto.Badge {
	if variant.FromCompany {
		badges = append(badges, &aviaSearchProto.Badge{
			Type:          aviaSearchProto.BadgeType_BADGE_TYPE_AVIACOMPANY_DIRECT_SELLING,
			OptionalValue: nil,
		})
	}

	return badges
}
