package badges

import (
	"context"

	aviaApi "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	commonV1 "a.yandex-team.ru/travel/app/backend/api/common/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
	"a.yandex-team.ru/travel/app/backend/internal/lib/aviabackendclient"
	"a.yandex-team.ru/travel/app/backend/internal/lib/aviatdapiclient"
	"a.yandex-team.ru/travel/avia/library/go/searchcontext"
)

type BackendClient interface {
	TopFlights(ctx context.Context, nationalVersion, lang string, fromKey, toKey, date string, limit int) (*aviabackendclient.TopFlightsRsp, error)
}

type AviaClients struct {
	AviaBackendClient BackendClient
}

type BadgeObserverBuilder interface {
	BuildToCache(
		ctx context.Context,
		clients *AviaClients,
		qid *searchcontext.QID,
		reference *aviatdapiclient.SearchResultReference,
	) ToCacheBadgeObserver

	BuildToResponse(
		ctx context.Context,
		clients *AviaClients,
		qid *searchcontext.QID,
		searchSort aviaApi.SearchSort,
		reference *aviaSearchProto.Reference,
		cacheSnippetStats *aviaSearchProto.CacheSnippetStats,
	) ToResponseBadgeObserver
}

type ToCacheBadgeObserver interface {
	ObserveRawVariant(variant *aviatdapiclient.SearchResultPrice, badges []*aviaSearchProto.Badge) []*aviaSearchProto.Badge
	ObserveSnippet(fare *aviatdapiclient.SearchResultFare, snippet *aviaSearchProto.Snippet) *aviaSearchProto.Snippet
	ObserveAllSnippets(snippets map[string]*aviaSearchProto.Snippet, cacheSnippetStats *aviaSearchProto.CacheSnippetStats) (map[string]*aviaSearchProto.Snippet, *aviaSearchProto.CacheSnippetStats)
}

type SnippetStats struct {
	BestPrice *commonV1.Price
}

type ToResponseBadgeObserver interface {
	ObserveSnippet(snippet *aviaApi.Snippet, stats *SnippetStats) *aviaApi.Snippet
}
