package transferobservers

import (
	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type AirportChangeObserver struct {
}

func NewAirportChangeObserver() *AirportChangeObserver {
	return &AirportChangeObserver{}
}

func (o *AirportChangeObserver) Observe(transfers *aviaSearchProto.Transfers) {
}

func (o *AirportChangeObserver) FillInitialFilterResponse(filters *aviaAPI.SearchFiltersReq, filterResponse *aviaAPI.SearchFiltersRsp) {
	filterResponse.Transfer.NoAirportChange = &aviaAPI.SearchFiltersRsp_BoolFilterState{
		Enabled: true,
		Value:   false,
	}
	if filters != nil && filters.Transfer != nil {
		filterResponse.Transfer.NoAirportChange.Value = filters.Transfer.NoAirportChange
	}
}

func (o *AirportChangeObserver) UpdateFilterResponse(filterResponse *aviaAPI.SearchFiltersRsp) {
}
