package transferobservers

import (
	aviaAPI "a.yandex-team.ru/travel/app/backend/api/avia/v1"
	aviaSearchProto "a.yandex-team.ru/travel/app/backend/internal/avia/search/proto/v1"
)

type TransferDurationObserver struct {
	minTransferDuration *uint32
	maxTransferDuration *uint32
}

func NewTransferDurationObserver() *TransferDurationObserver {
	return &TransferDurationObserver{
		minTransferDuration: nil,
		maxTransferDuration: nil,
	}
}

func (o *TransferDurationObserver) Observe(transfers *aviaSearchProto.Transfers) {
	for _, t := range transfers.ForwardTransfers {
		if o.minTransferDuration == nil || *o.minTransferDuration > t.DurationMinutes {
			o.minTransferDuration = &t.DurationMinutes
		}
		if o.maxTransferDuration == nil || *o.maxTransferDuration < t.DurationMinutes {
			o.maxTransferDuration = &t.DurationMinutes
		}
	}
	for _, t := range transfers.BackwardTransfers {
		if o.minTransferDuration == nil || *o.minTransferDuration > t.DurationMinutes {
			o.minTransferDuration = &t.DurationMinutes
		}
		if o.maxTransferDuration == nil || *o.maxTransferDuration < t.DurationMinutes {
			o.maxTransferDuration = &t.DurationMinutes
		}
	}
}

func (o *TransferDurationObserver) FillInitialFilterResponse(filters *aviaAPI.SearchFiltersReq, filterResponse *aviaAPI.SearchFiltersRsp) {
	if o.minTransferDuration == nil || o.maxTransferDuration == nil {
		return
	}
	filterResponse.Transfer.TransferDuration = &aviaAPI.SearchFiltersRsp_TransferDurationFilter{
		All: &aviaAPI.SearchFiltersRsp_TransferDurationInterval{
			MinimumMinutes: *o.minTransferDuration,
			MaximumMinutes: *o.maxTransferDuration,
		},
		Selected: &aviaAPI.SearchFiltersRsp_TransferDurationInterval{
			MinimumMinutes: *o.minTransferDuration,
			MaximumMinutes: *o.maxTransferDuration,
		},
	}

	if filters == nil || filters.Transfer == nil || filters.Transfer.TransferDuration == nil {
		return
	}
	minSelected := filters.Transfer.TransferDuration.MinimumMinutes
	if minSelected > *o.minTransferDuration {
		filterResponse.Transfer.TransferDuration.Selected.MinimumMinutes = minSelected
	}
	maxSelected := filters.Transfer.TransferDuration.MaximumMinutes
	if maxSelected < *o.maxTransferDuration {
		filterResponse.Transfer.TransferDuration.Selected.MaximumMinutes = maxSelected
	}
}

func (o *TransferDurationObserver) UpdateFilterResponse(filterResponse *aviaAPI.SearchFiltersRsp) {
}
